// -----------------------------------------------------------------------------------------------------------------------
// Rendering a flat, textured sphere in CSharpCalc 3D
// -----------------------------------------------------------------------------------------------------------------------

// 2D surface initialization
// -----------------------------------------------------------------------------------------------------------------------
CSCDisplay.SetSurfaceSize(800, 600);
CSCDisplay.SetPhysicalSize(-1, -1, 1, 1);
CSCDisplay.Clear(Color.Black);

// 3D scene setup

// -----------------------------------------------------------------------------------------------------------------------
// Place the camera at position (5.0, 5.0, 5.0) in global coordinates
CSC3DScene.SetCameraPosition(5.0, 5.0, 5.0);

// Let the camera point towards the origin of the global coordinate system
CSC3DScene.SetCameraLookAt(0.0, 0.0, 0.0);

// Enable directional lighting
CSC3DScene.SetDirectionalLightColor(255, 255, 255);
CSC3DScene.SetLightDirection(-0.5, 0.5, -1.5);

// Enable ambient lighting
CSC3DScene.SetAmbientLightColor(100, 100, 100);

// 3D scene construction
// -----------------------------------------------------------------------------------------------------------------------
CSC3DScene.BeginConstruction();

// Use the factory to create a sphere...
CSC3DObject SPHERE = CSC3DFactory.CreateSphere(0.5, 16, 16);

// Create a checkerboard texture. First define a style, then create the texture using that style.
CSC3DTextureStyle style = new CSC3DTextureStyle(Color.Orange, Color.Blue, 3);
CSC3DTexture TEX = new CSC3DTexture(CSC3DTextureType.Checker, CSC3DTextureSize.Medium, style);

// Specify the sphere's ambient surface material to be the texture created above
SPHERE.SetDiffuse(TEX);

// Apply a flat shading transformation ..
SPHERE.Flatten();

// .. and add the sphere to the scene
CSC3DScene.Add(SPHERE);

CSC3DScene.EndConstruction();

// Scene rendering and presentation
// -----------------------------------------------------------------------------------------------------------------------
CSCDisplay.BeginRendering();
CSC3DScene.Render();
CSCDisplay.EndRendering();
CSCDisplay.Present();