// -----------------------------------------------------------------------------------------------------------------------
// Rendering an extruded circle segment in CSharpCalc 3D
// -----------------------------------------------------------------------------------------------------------------------

// 2D surface initialization
// -----------------------------------------------------------------------------------------------------------------------
CSCDisplay.SetSurfaceSize(800, 600);
CSCDisplay.SetPhysicalSize(-1, -1, 1, 1);
CSCDisplay.Clear(Color.Black);

// 3D scene setup

// -----------------------------------------------------------------------------------------------------------------------
// Place the camera at position (5.0, 5.0, 5.0) in global coordinates
CSC3DScene.SetCameraPosition(5.0, 5.0, 5.0);

// Let the camera point towards the origin of the global coordinate system
CSC3DScene.SetCameraLookAt(0.0, 0.0, 0.0);

// Enable directional lighting
CSC3DScene.SetDirectionalLightColor(255, 255, 255);
CSC3DScene.SetLightDirection(-0.5, -0.5, -1.5);

// Disable ambient lighting
CSC3DScene.SetAmbientLightColor(0, 0, 0);

// 3D scene construction
// -----------------------------------------------------------------------------------------------------------------------
CSC3DScene.BeginConstruction();

// Create a circle segment to be used as extrusion object.
CSC3DObject BaseOBJ = CSC3DFactory.CreateCircleSegment(1.0, 90.0, 330.0, 6, 0.0, 0.0, 0.0);

// Convert the circle segment to a convex area object to be used as caps.
CSC3DObject CapOBJ = CSC3DFactory.CreateConvexArea(BaseOBJ);

// Create a sequence of radii for modulating the extruded object's rings
double[] R = new double[] { 0.8, 0.8, 0.5, 0.8, 0.5 };

// Using the above information, create the extruded object and move it.
CSC3DObjectGroup G = CSC3DFactory.CreateExtrudedObject(BaseOBJ, CapOBJ, 2.0, R);
G.MoveRel(0.0, 0.0, -1.0);

// Apply a procedural texture to the three object parts.
CSC3DTextureStyle style = new CSC3DTextureStyle(Color.Gray, Color.White, 4);
G[0].SetDiffuse(new CSC3DTexture(CSC3DTextureType.Checker, CSC3DTextureSize.Small, style));

// Change the texture style.
style.Level = 1;
G[1].SetDiffuse(new CSC3DTexture(CSC3DTextureType.Checker, CSC3DTextureSize.Small, style));
G[2].SetDiffuse(new CSC3DTexture(CSC3DTextureType.Checker, CSC3DTextureSize.Small, style));

// Add the extruded object to the scene.
CSC3DScene.Add(G);

CSC3DScene.EndConstruction();

// Scene rendering and presentation
// -----------------------------------------------------------------------------------------------------------------------
CSCDisplay.BeginRendering();
CSC3DScene.Render();
CSCDisplay.EndRendering();
CSCDisplay.Present();