// -----------------------------------------------------------------------------------------------------------------------
// Rendering a function surface in CSharpCalc 3D
// -----------------------------------------------------------------------------------------------------------------------

// 2D surface initialization
// -----------------------------------------------------------------------------------------------------------------------
CSCDisplay.SetSurfaceSize(800, 600);
CSCDisplay.SetPhysicalSize(-1, -1, 1, 1);
CSCDisplay.Clear(Color.Black);

// 3D scene setup

// -----------------------------------------------------------------------------------------------------------------------
// Place the camera at position (5.0, 5.0, 5.0) in global coordinates
CSC3DScene.SetCameraPosition(5.0, 5.0, 5.0);

// Let the camera point towards the origin of the global coordinate system
CSC3DScene.SetCameraLookAt(0.0, 0.0, 0.0);

// Enable directional lighting
CSC3DScene.SetDirectionalLightColor(255, 255, 255);
CSC3DScene.SetLightDirection(-0.5, -0.5, -1.5);

// Disable ambient lighting
CSC3DScene.SetAmbientLightColor(0, 0, 0);

// 3D scene construction
// -----------------------------------------------------------------------------------------------------------------------
CSC3DScene.BeginConstruction();

// Create a style for the texture
CSC3DTextureStyle style = new CSC3DTextureStyle(Color.White, Color.Gray, 4);

// Create a height field object. The height field itself is defined in the classcode below.
CSC3DObject OBJ = CSC3DFactory.CreateHeightField(4.0, 4.0, HeightField.Create());

// Specify the texture to be a line grid rendered in the above style.
OBJ.SetDiffuse(new CSC3DTexture(CSC3DTextureType.Grid, CSC3DTextureSize.Large, style));

// Add the height field object to the scene.
CSC3DScene.Add(OBJ);

CSC3DScene.EndConstruction();

// Scene rendering and presentation
// -----------------------------------------------------------------------------------------------------------------------
CSCDisplay.BeginRendering();
CSC3DScene.Render();
CSCDisplay.EndRendering();
CSCDisplay.Present();

/* <classcode> */
// This class generates a height field example.
public static class HeightField
{
 public static double[ , ] Create()
 {
  double[ , ] Z = new double[tiles + 1, tiles + 1];

  for(int j = 0; j <= tiles; j++)
  {
   for(int i = 0; i <= tiles; i++)
   {
    double x = 2.0*(-1.0 + 2.0*i/tiles);
    double y = 2.0*(-1.0 + 2.0*j/tiles);
    double r2 = x*x + y*y;
    Z[i, j] = -0.3*Math.Exp(-1.0*r2*r2 + 2.0*r2);
   }
  }
  return Z;
 }
 const int tiles = 64;
}