/*

 This script is part of the CSharpCalc documentation. Use and modify this script
 free of charge but on your own risk, without warranty and without liability. The
 sole purpose of this script is the practical documentation of certain features
 of the CSharpCalc software. It is not suited for any commercial use. Whenever
 given, additional instructions contained in this script are important must be
 followed prior to starting this script in CSharpCalc.

 Version requirement: CSharpCalc version 1.0 all revisions.
*/
// This CSharpCalc script calculates the first 50 Fibonacci numbers define
// variables for storing the last 2 Fibonacci numbers and initialize them.
long X = 0;
long Y = 1;
long F = X + Y;

// the quotient: F[n]/F[n-1] approaches the golden ration as n
// goes to infinity. We shall display this quotient as n tends to 50 :)
double quotient = 1.0;

// first print out a nice header CSCConsole.Writeln("================================================");
CSCConsole.Writeln("Table of the first 50 Fibonacci numbers (F1-F50)");
CSCConsole.Writeln("================================================");

// print the first Fibonacci number stored in F1
CSCConsole.Write("F01: " + Y.ToString().PadLeft(15));
CSCConsole.Write("  F01/F00:  undefined");
CSCConsole.Writeln();

// iterate for calculating the remaining 49 Fibonacci numbers using the // recursion F[n] = F[n-1] + F[n-2] Initially the register F contains F2!


for(int i = 2; i <= 50; i++)
{
 // print the current Fibonacci number stored in FN
 CSCConsole.Write("F" + i.ToString("00").PadLeft(2));
 CSCConsole.Write(": " + F.ToString().PadLeft(15));
 string qlabel = " F" + i.ToString("00") + "/F" + (i-1).ToString("00") + ": ";
 CSCConsole.Write(qlabel.PadLeft(11) + quotient.ToString("0.00000000"));
 CSCConsole.Writeln();

 // recursively calculate the next Fibonacci number and the next quotient.
X = Y; Y = F; F = X + Y; quotient = (double)F/(double)Y;
}
// print a terminating horizontal ruler
CSCConsole.Writeln("==============================================");

// finally store the text displayed in a file named fibonacci.txt in your
// active data directory
CSCConsole.SaveText("fibonacci.txt");