/*

 This script is part of the CSharpCalc documentation. Use and modify this script
 free of charge but on your own risk, without warranty and without liability. The
 sole purpose of this script is the practical documentation of certain features
 of the CSharpCalc software. It is not suited for any commercial use. Whenever
 given, additional instructions contained in this script are important must be
 followed prior to starting this script in CSharpCalc.

 Version requirement: CSharpCalc version 1.0 all revisions.
*/
// initialize console and display. the physical size will be specified by
// CSCFunctionPlot.Initialize() below this block and needs no
// specification here.
CSCConsole.Clear();
CSCDisplay.SetSurfaceSize(1000, 500);

// initialize the SCSFunctionPlot class. this version, without parameters
// adapts the physical size to the extensions of the first function plotted.
CSCFunctionPlot.Initialize();

// set a style for the function graph green color and 2.0 line width
CSCFunctionPlot.SetStyle(Color.Green, 2.0);

// plot the function graph. the Gaussian class is defined below
CSCFunctionPlot.Plot(new Gaussian(2.0, -2.0, 2.0, -10.0, 10.0, 150));

// and show the resulting rendering in the display
CSCDisplay.Present();

/* <classcode> */
public class Gaussian : CSCRealFunction
{
 public Gaussian(double A, double mu, double sigma, double xmin, double xmax, int numsamples) : base(xmin, xmax)
 {
  _sigma = sigma;
  _mu = mu;
  _a = A;
  Resample(numsamples);
 }

 public override double Value(double x)
 {
  return _a*(1.0/Math.Sqrt(2.0*Math.PI*_sigma))*Math.Exp(-(x - _mu)*(x - _mu)/(2.0*_sigma));
 }

 private double _sigma = 1.0;
 private double _mu = 0.0;
 private double _a = 1.0;
}