// -----------------------------------------------------------------------------------------------------------------------
// Object transformations in CSharpCalc 3D
// -----------------------------------------------------------------------------------------------------------------------

// 2D surface initialization
// -----------------------------------------------------------------------------------------------------------------------
CSCDisplay.SetSurfaceSize(800, 600);
CSCDisplay.SetPhysicalSize(-1, -1, 1, 1);
CSCDisplay.Clear(Color.Black);

// 3D scene setup

// -----------------------------------------------------------------------------------------------------------------------
// place the camera at position (5.0, 5.0, 5.0) in global coordinates
CSC3DScene.SetCameraPosition(15.0, 15.0, 15.0);

// let the camera point towards the origin of the global coordinate system
CSC3DScene.SetCameraLookAt(0.0, 0.0, 0.0);

// enable directional lighting
CSC3DScene.SetDirectionalLightColor(255, 255, 255);
CSC3DScene.SetLightDirection(-0.5, 0.5, -1.5);

// enable ambient lighting
CSC3DScene.SetAmbientLightColor(100, 100, 100);

// 3D scene construction
// -----------------------------------------------------------------------------------------------------------------------
CSC3DScene.BeginConstruction();

// Use the factory to create a cube of size 1 x 1 x 1
CSC3DObject MASTERCUBE = CSC3DFactory.CreateCube();
MASTERCUBE.Scale(0.5);

// Specify the sphere's ambient surface material to be the texture created above
MASTERCUBE.SetDiffuse(200, 0, 0);

// Create two clones of the master cube and position them in two points. One cube is also rotated.
CSC3DObject CUBE1 = MASTERCUBE.Clone();
CUBE1.Rotate(0.0, 0.0, 1.0, 45.0);
CUBE1.MoveTo(0.5, -0.5, 0.0);
CSC3DScene.Add(CUBE1);

CSC3DObject CUBE2 = MASTERCUBE.Clone();
CUBE2.MoveTo(-0.5, 0.5, 1.0);
CSC3DScene.Add(CUBE2);

CSC3DScene.EndConstruction();

// Scene rendering and presentation
// -----------------------------------------------------------------------------------------------------------------------
CSCDisplay.BeginRendering();
CSC3DScene.Render();
CSCDisplay.EndRendering();
CSCDisplay.Present();