// -----------------------------------------------------------------------------------------------------------------------
// Construction of an object group in CSharpCalc 3D
// -----------------------------------------------------------------------------------------------------------------------

// 2D surface initialization
// -----------------------------------------------------------------------------------------------------------------------
CSCDisplay.SetSurfaceSize(800, 600);
CSCDisplay.SetPhysicalSize(-1, -1, 1, 1);
CSCDisplay.Clear(Color.Black);

// 3D scene setup

// -----------------------------------------------------------------------------------------------------------------------
// place the camera at position (5.0, 5.0, 5.0) in global coordinates
CSC3DScene.SetCameraPosition(5.0, 5.0, 5.0);

// let the camera point towards the origin of the global coordinate system
CSC3DScene.SetCameraLookAt(0.0, 0.0, 0.0);

// enable directional lighting
CSC3DScene.SetDirectionalLightColor(255, 255, 255);
CSC3DScene.SetLightDirection(-0.5, 0.5, -1.5);

// enable ambient lighting
CSC3DScene.SetAmbientLightColor(100, 100, 100);

// 3D scene construction
// -----------------------------------------------------------------------------------------------------------------------
CSC3DScene.BeginConstruction();

// Use the factory to create a cube of size 1 x 1 x 1
CSC3DObject MASTERCUBE = CSC3DFactory.CreateCube();
MASTERCUBE.Scale(0.5);

// Create an empty object group
CSC3DObjectGroup CUBEGROUP = new CSC3DObjectGroup();

// specify the sphere's ambient surface material to be the texture created above
MASTERCUBE.SetDiffuse(200, 0, 0);

// create two clones of the master cube and position them in two points
CSC3DObject CUBE1 = MASTERCUBE.Clone();
CUBE1.Scale(0.5, 0.5, 1.0);
CUBE1.MoveTo(0.5, -0.5, 0.0);

// add the first cube to the group
CUBEGROUP.Add(CUBE1);

CSC3DObject CUBE2 = MASTERCUBE.Clone();
CUBE2.Scale(0.5, 0.5, 1.0);
CUBE2.MoveTo(-0.5, 0.5, 0.0);

// add the second cube to the group
CUBEGROUP.Add(CUBE2);

// now transform the entire group
CUBEGROUP.MoveTo(0.0, 0.0, -1.0);
CUBEGROUP.Rotate(1.0, 1.0, 0.0, 45.0);

// finally add the entire group to the scene
CSC3DScene.Add(CUBEGROUP);

// for better orientation also add a colored coordinate cross to the scene
CSC3DObjectGroup COORDS = CSC3DFactory.CreateCoordinateCross(2.0, 0.05, 1.0, 0.0);
CSC3DScene.Add(COORDS);

CSC3DScene.EndConstruction();

// Scene rendering and presentation
// -----------------------------------------------------------------------------------------------------------------------
CSCDisplay.BeginRendering();
CSC3DScene.Render();
CSCDisplay.EndRendering();
CSCDisplay.Present();

// finally, write information on CUBEGROUP to the console
CSCConsole.Writeln(CUBEGROUP.ToString());