// -----------------------------------------------------------------------------------------------------------------------
// Construction of an atom-like structure. Aadvanced object groups.
// -----------------------------------------------------------------------------------------------------------------------

// 2D surface initialization
// -----------------------------------------------------------------------------------------------------------------------
CSCDisplay.SetSurfaceSize(800, 600);
CSCDisplay.SetPhysicalSize(-1, -1, 1, 1);
CSCDisplay.Clear(Color.Black);

// 3D scene setup

// -----------------------------------------------------------------------------------------------------------------------
// Place the camera at position (5.0, 5.0, 5.0) in global coordinates
CSC3DScene.SetCameraPosition(5.0, 5.0, 5.0);

// Let the camera point towards the origin of the global coordinate system
CSC3DScene.SetCameraLookAt(0.0, 0.0, 0.0);

// Enable directional lighting
CSC3DScene.SetDirectionalLightColor(255, 255, 255);
CSC3DScene.SetLightDirection(-0.5, 0.5, -1.5);

// Enable ambient lighting
CSC3DScene.SetAmbientLightColor(100, 100, 100);

// 3D scene construction
// -----------------------------------------------------------------------------------------------------------------------
CSC3DScene.BeginConstruction();

// Create an object group named ATOMS
CSC3DObjectGroup ATOMS = new CSC3DObjectGroup();

// We shall use this reference for object clones
CSC3DObject OBJ = null;

// Create a sphere for representing the atoms
CSC3DObject SPHERE = CSC3DFactory.CreateSphere(0.2, 32, 32);

// Create a cylinder for representing the connections between atoms.
CSC3DObject CYLINDER = CSC3DFactory.CreateCylinder(0.05, 2, 32);

// Add 7 atoms to the group
OBJ = SPHERE.Clone(); OBJ.MoveTo(0.0, 0.0, 0.0); ATOMS.Add(OBJ);
OBJ = SPHERE.Clone(); OBJ.MoveTo(1.0, 0.0, 0.0); ATOMS.Add(OBJ);
OBJ = SPHERE.Clone(); OBJ.MoveTo(-1.0, 0.0, 0.0); ATOMS.Add(OBJ);
OBJ = SPHERE.Clone(); OBJ.MoveTo(0.0, 1.0, 0.0); ATOMS.Add(OBJ);
OBJ = SPHERE.Clone(); OBJ.MoveTo(0.0, -1.0, 0.0); ATOMS.Add(OBJ);
OBJ = SPHERE.Clone(); OBJ.MoveTo(0.0, 0.0, 1.0); ATOMS.Add(OBJ);
OBJ = SPHERE.Clone(); OBJ.MoveTo(0.0, 0.0, -1.0); ATOMS.Add(OBJ);

// Create cylinders spanned between the atom positions to connect the atoms
// Connections to center
OBJ = CSC3DFactory.CreateObject(CYLINDER, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0); ATOMS.Add(OBJ);
OBJ = CSC3DFactory.CreateObject(CYLINDER, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0); ATOMS.Add(OBJ);
OBJ = CSC3DFactory.CreateObject(CYLINDER, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0); ATOMS.Add(OBJ);
OBJ = CSC3DFactory.CreateObject(CYLINDER, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0); ATOMS.Add(OBJ);
OBJ = CSC3DFactory.CreateObject(CYLINDER, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0); ATOMS.Add(OBJ);
OBJ = CSC3DFactory.CreateObject(CYLINDER, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0); ATOMS.Add(OBJ);

// Connections in the xy plane
OBJ = CSC3DFactory.CreateObject(CYLINDER, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0); ATOMS.Add(OBJ);
OBJ = CSC3DFactory.CreateObject(CYLINDER, 0.0, 1.0, 0.0, -1.0, 0.0, 0.0); ATOMS.Add(OBJ);
OBJ = CSC3DFactory.CreateObject(CYLINDER, -1.0, 0.0, 0.0, 0.0, -1.0, 0.0); ATOMS.Add(OBJ);
OBJ = CSC3DFactory.CreateObject(CYLINDER, 0.0, -1.0, 0.0, 1.0, 0.0, 0.0); ATOMS.Add(OBJ);

// Side connections to upper atom
OBJ = CSC3DFactory.CreateObject(CYLINDER, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0); ATOMS.Add(OBJ);
OBJ = CSC3DFactory.CreateObject(CYLINDER, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0); ATOMS.Add(OBJ);
OBJ = CSC3DFactory.CreateObject(CYLINDER, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0); ATOMS.Add(OBJ);
OBJ = CSC3DFactory.CreateObject(CYLINDER, 0.0, -1.0, 0.0, 0.0, 0.0, 1.0); ATOMS.Add(OBJ);

// Side connection to lower atom
OBJ = CSC3DFactory.CreateObject(CYLINDER, 1.0, 0.0, 0.0, 0.0, 0.0, -1.0); ATOMS.Add(OBJ);
OBJ = CSC3DFactory.CreateObject(CYLINDER, -1.0, 0.0, 0.0, 0.0, 0.0, -1.0); ATOMS.Add(OBJ);
OBJ = CSC3DFactory.CreateObject(CYLINDER, 0.0, 1.0, 0.0, 0.0, 0.0, -1.0); ATOMS.Add(OBJ);
OBJ = CSC3DFactory.CreateObject(CYLINDER, 0.0, -1.0, 0.0, 0.0, 0.0, -1.0); ATOMS.Add(OBJ);

// Assign a different material to one of the objects
ATOMS[19].SetDiffuse(200, 0, 0);

CSC3DScene.Add(ATOMS);

// For better orientation also add a coordinate cross to the scene
CSC3DObjectGroup COORDS = CSC3DFactory.CreateCoordinateCross(2.0, 0.02);
CSC3DScene.Add(COORDS);

CSC3DScene.EndConstruction();

// Scene rendering and presentation
// -----------------------------------------------------------------------------------------------------------------------
CSCDisplay.BeginRendering();
CSC3DScene.Render();
CSCDisplay.EndRendering();
CSCDisplay.Present();