// -----------------------------------------------------------------------------------------------------------------------
// Rendering an open 3D coordinate frame with labels in CSharpCalc
// The coordinate frame spans the volume [-1, 1] x [-1, 1] x [0, 2]
// -----------------------------------------------------------------------------------------------------------------------

// 2D surface initialization
// -----------------------------------------------------------------------------------------------------------------------
CSCDisplay.SetSurfaceSize(800, 600);
CSCDisplay.SetPhysicalSize(-1, -1, 1, 1);
CSCDisplay.Clear(Color.White);

// 3D scene setup - needs to be finished before constructing the labels here in order to make them face the camera.
// -----------------------------------------------------------------------------------------------------------------------
// Place the camera at position (3.0, 5.0, 4.0) in global coordinates
CSC3DScene.SetCameraPosition(3.0, 5.0, 4.0);

// Let the camera point towards the center of the coordinate frame - not the coordinate origin!
CSC3DScene.SetCameraLookAt(0.0, 0.0, 1.0);

// Enable directional lighting
CSC3DScene.SetDirectionalLightColor(255, 255, 255);
CSC3DScene.SetLightDirection(-1.0, -0.75, -1.5);

// Enable ambient lighting
CSC3DScene.SetAmbientLightColor(55, 55, 55);

// 3D scene construction
// -----------------------------------------------------------------------------------------------------------------------
CSC3DScene.BeginConstruction();

// ceate a style for the textures
CSC3DTextureStyle style = new CSC3DTextureStyle(Color.Black, Color.White, 3, 3, 1.0, 1.0);

// create a grid texture for the back planes
CSC3DTexture gridtex = new CSC3DTexture(CSC3DTextureType.Grid, CSC3DTextureSize.Large, style);

// also create label textures
CSC3DTexture label00 = new CSC3DTexture("-1.0", CSC3DTextureSize.Medium, style);
CSC3DTexture label01 = new CSC3DTexture("0.0",   CSC3DTextureSize.Medium, style);
CSC3DTexture label02 = new CSC3DTexture("1.0",  CSC3DTextureSize.Medium, style);
CSC3DTexture label03 = new CSC3DTexture("2.0",  CSC3DTextureSize.Medium, style);

// create the frame box using the factory
CSC3DObjectGroup BOX = CSC3DFactory.CreateOpenFrameBox(0.02, -1.0, -1.0, 0.0, 1.0, 1.0, 2.0, true);

// Patch the grid textures to the frame box ..
BOX[0].SetDiffuse(gridtex);
BOX[1].SetDiffuse(gridtex);
BOX[2].SetDiffuse(gridtex);

// .. and add the box
CSC3DScene.Add(BOX);

// Add text labes and position them accordingly. Add small offsets for better visual appearance.
CSC3DScene.Add(CSC3DFactory.Create3DLabel(-1.0, 1.12, 0.0, 0.1, label00));
CSC3DScene.Add(CSC3DFactory.Create3DLabel( 0.0, 1.12, 0.0, 0.1, label01));

CSC3DScene.Add(CSC3DFactory.Create3DLabel( 1.05, 1.08, 0.0, 0.1, label02));

CSC3DScene.Add(CSC3DFactory.Create3DLabel(1.1, -1.0, 0.0, 0.1, label00));
CSC3DScene.Add(CSC3DFactory.Create3DLabel(1.1,  0.0, 0.0, 0.1, label01));

CSC3DScene.Add(CSC3DFactory.Create3DLabel(1.1, -1.0, 0.1, 0.1, label01));
CSC3DScene.Add(CSC3DFactory.Create3DLabel(1.1, -1.0, 1.0, 0.1, label02));
CSC3DScene.Add(CSC3DFactory.Create3DLabel(1.1, -1.0, 2.0, 0.1, label03));

CSC3DScene.EndConstruction();

// Scene rendering and presentation
// -----------------------------------------------------------------------------------------------------------------------
CSCDisplay.BeginRendering();
CSC3DScene.Render();
CSCDisplay.EndRendering();
CSCDisplay.Present();