/*

 This script is part of the CSharpCalc documentation. Use and modify this script
 free of charge but on your own risk, without warranty and without liability. The
 sole purpose of this script is the practical documentation of certain features
 of the CSharpCalc software. It is not suited for any commercial use. Whenever
 given, additional instructions contained in this script are important must be
 followed prior to starting this script in CSharpCalc.

 Version requirement: CSharpCalc version 1.0 all revisions.
*/
/* <maincode> */

// initialize the Fibonacci class
Fibonacci.Initialize(0, 1);

// compute the sequence and the ratios
Fibonacci.Calculate(50);

// write the results to the console
CSCConsole.Writeln(Fibonacci.TextOutput());

// finally store the console text
CSCConsole.SaveText("fibonacci.txt");

/* <classcode> */
public static class Fibonacci
{
 public static void Initialize(int f0, int f1)
 {
  _X = (long)f0;
  _Y = (long)f1;
 }

 // this method calculates the first n members of the sequence
 // and stores them along with the ratios in the F and R lists.
 public static void Calculate(int n)
 {
  F.Add(_X); R.Add(0.0);
  F.Add(_Y); R.Add(0.0);
  long f = _X + _Y;
  double r = ((double)f) / ((double)_Y);
  for(int i = 2; i <= n; i++)
  {
   F.Add(f); R.Add(r);
   _X = _Y; _Y = f; f = _X + _Y;
   r = ((double)f) / ((double)_Y);
  }
 }

 // this method returns formatted text output
 public static string TextOutput()
 {
  int N = F.Count - 1;
  StringBuilder SB = new StringBuilder();
  SB.Append("================================================\r\n");
  SB.Append("The first " + N.ToString() + " Fibonacci numbers\r\n");
  SB.Append("================================================\r\n");
  for(int i = 1; i <= N; i++)
  {
   SB.Append("F" + i.ToString().PadLeft(2));
   SB.Append(": " + F[i].ToString().PadLeft(15));
   string qlabel = " F" + i.ToString() + "/F" + (i-1).ToString() + ": ";
   SB.Append(qlabel.PadLeft(18) + R[i].ToString("0.00000000"));
   SB.Append("\r\n");
  }
  SB.Append("================================================");
  return SB.ToString();
 }

 // public accessors
 public static List<long> F { get { return _f; } }
 public static List<double> R { get { return _r; } }

 // private variables
 private static long _X = 0;
 private static long _Y = 1;

 // two lists for storing the sequence and the ratios
 private static List<long>      _f = new List<long>();
 private static List<double>    _r = new List<double>();
}