/*

 This script is part of the CSharpCalc documentation. Use and modify this script
 free of charge but on your own risk, without warranty and without liability. The
 sole purpose of this script is the practical documentation of certain features
 of the CSharpCalc software. It is not suited for any commercial use. Whenever
 given, additional instructions contained in this script are important must be
 followed prior to starting this script in CSharpCalc.

 Version requirement: CSharpCalc version 1.0 all revisions.
*/
// specify the size of the surface (i.e. the image size) in pixels
CSCDisplay.SetSurfaceSize(600, 450);

// also specify the size of the display in physical units.
// This call specifies a rectangle by its corner points (-1, -1) and (1, 1).
CSCDisplay.SetPhysicalSize(-1.0, -1.0, 1.0, 1.0);

// Initialize the surface with white as background color.
CSCDisplay.Clear(Color.White);

// Begin the rendering process
CSCDisplay.BeginRendering();

// Render a few simple primitives. Geometry is defined in physical units.
CSCRender2D.DrawRectangle(-0.5, -0.5, 0.25);
CSCRender2D.FillRectangle(0.0, 0.0, 0.15);
CSCRender2D.DrawRectangle(0.5, -0.5, 0.25);

// Finish the rendering process
CSCDisplay.EndRendering();

// Present the surface in the CSharpCalc display
CSCDisplay.Present();