/*

 This script is part of the CSharpCalc documentation. Use and modify this script
 free of charge but on your own risk, without warranty and without liability. The
 sole purpose of this script is the practical documentation of certain features
 of the CSharpCalc software. It is not suited for any commercial use. Whenever
 given, additional instructions contained in this script are important must be
 followed prior to starting this script in CSharpCalc.

 Version requirement: CSharpCalc version 1.0 all revisions.
*/
// set the display's surface size
CSCDisplay.SetSurfaceSize(1000, 500);

// initialize the pysical extensions of the coordinates. This is similar
// but not equal to calling CSCDisplay.SetPhysicalSize().
CSCFunctionPlot.Initialize(-8.0, 0.0, 8.0, 4.5);

// Set the margins of the coordinate frame in %
CSCFunctionPlot.SetMargins(10, 10, 50, 20);

// This version of SetStyle controls which parts of the coordinate frame
// will be plotted.
CSCFunctionPlot.SetStyle(true, true, true);

// Set styles for axes, the grid and the frame
CSCFunctionPlot.SetAxesStyle(Color.Black, 2.0);
CSCFunctionPlot.SetGridStyle(Color.Gray, 1.0);
CSCFunctionPlot.SetFrameStyle(Color.SlateGray, 1.0);

// Specify an offest for the legend text in pixels. Here, text will be
// displaced 2 pixels in the X direction and 10 pixels in the Y direction.
CSCFunctionPlot.SetLegendTextOffset(2, 10);

// plot the delta sequence CSCFunctionPlot.SetStyle(Color.Black, 2.0);
CSCFunctionPlot.Plot(new Gaussian(1.0, 0.0, 0.01, -10.0, 10.0, 500));

// This method plots an entry in the legend
CSCFunctionPlot.PlotLegend(9.5, 0.6, "small sigma value (0.01)", 1.2);

CSCFunctionPlot.SetStyle(Color.Gray, 1.0);
CSCFunctionPlot.Plot(new Gaussian(1.0, 0.0, 0.05, -10.0, 10.0, 500));
CSCFunctionPlot.Plot(new Gaussian(1.0, 0.0, 0.1, -10.0, 10.0, 500));
CSCFunctionPlot.Plot(new Gaussian(1.0, 0.0, 0.25, -10.0, 10.0, 500));
CSCFunctionPlot.Plot(new Gaussian(1.0, 0.0, 0.5, -10.0, 10.0, 500));
CSCFunctionPlot.Plot(new Gaussian(1.0, 0.0, 1.0, -10.0, 10.0, 500));
CSCFunctionPlot.PlotLegend(9.5, 0.3, "intermediate sigma values", 1.2);

CSCFunctionPlot.SetStyle(Color.DarkRed, 2.0);
CSCFunctionPlot.Plot(new Gaussian(1.0, 0.0, 2.0, -10.0, 10.0, 500));
CSCFunctionPlot.PlotLegend(9.5, 0.0, "large sigma value (2.00);", 1.2);

// add own, custom features. in our case a headline
CSCDisplay.BeginRendering();
CSCRender2D.DrawCenteredText(0.0, 4.6, "Gaussian delta sequence", 0, 0);
CSCDisplay.EndRendering();

CSCDisplay.Present();

/* <classcode> */
public class Gaussian : CSCRealFunction
{
 public Gaussian(double A, double mu, double sigma, double xmin, double xmax, int numsamples) : base(xmin, xmax)
 {
  _sigma = sigma;
  _mu = mu;
  _a = A;
  Resample(numsamples);
 }

 public override double Value(double x)
 {
  return _a*(1.0/Math.Sqrt(2.0*Math.PI*_sigma))*Math.Exp(-(x - _mu)*(x - _mu)/(2.0*_sigma));
 }

 private double _sigma = 1.0;
 private double _mu = 0.0;
 private double _a = 1.0;
}